/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.parsing;

import beaver.Parser;
import beaver.Symbol;
import com.aptana.parsing.IParser;
import com.aptana.parsing.IRecoveryStrategy;
import com.aptana.parsing.lexer.ITypePredicate;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InsertionRecoveryStrategy<T extends ITypePredicate>
implements IRecoveryStrategy {
    private List<CandidateToken> candidateTokens = new ArrayList<CandidateToken>();
    private Set<Short> lastTypes = new HashSet<Short>();
    private Set<Short> currentTypes = new HashSet<Short>();

    public InsertionRecoveryStrategy(T type, String text, T ... lastTokenTypes) {
        this.addToken(type, text);
        this.addLastTokenTypes((ITypePredicate[])lastTokenTypes);
    }

    public InsertionRecoveryStrategy(T type1, String text1, T type2, String text2, T ... lastTokenTypes) {
        this.addToken(type1, text1);
        this.addToken(type2, text2);
        this.addLastTokenTypes((ITypePredicate[])lastTokenTypes);
    }

    public void addCurrentTokenTypes(T ... tokenTypes) {
        T[] TArray = tokenTypes;
        int n = tokenTypes.length;
        int n2 = 0;
        while (n2 < n) {
            T tokenType = TArray[n2];
            this.currentTypes.add(tokenType.getIndex());
            ++n2;
        }
    }

    public void addLastTokenTypes(T ... tokenTypes) {
        T[] TArray = tokenTypes;
        int n = tokenTypes.length;
        int n2 = 0;
        while (n2 < n) {
            T tokenType = TArray[n2];
            this.lastTypes.add(tokenType.getIndex());
            ++n2;
        }
    }

    public void addToken(T tokenType, String text) {
        this.candidateTokens.add(new CandidateToken(this, (ITypePredicate)tokenType, text));
    }

    @Override
    public boolean recover(IParser parser, Symbol lastToken, Symbol currentToken, Parser.TokenStream in, Parser.Events report) throws IOException {
        boolean result = false;
        if (this.candidateTokens.size() > 0 && (this.lastTypes.size() == 0 || this.lastTypes.contains(lastToken.getId())) && (this.currentTypes.size() == 0 || this.currentTypes.contains(currentToken.getId()))) {
            in.alloc(this.candidateTokens.size() + 1);
            in.insert(currentToken);
            ArrayList<Symbol> terminals = new ArrayList<Symbol>(this.candidateTokens.size());
            int tokenStart = lastToken.getEnd() + 1;
            int tokenEnd = tokenStart - 1;
            for (CandidateToken candidateToken : this.candidateTokens) {
                short id = candidateToken.tokenType.getIndex();
                String text = candidateToken.tokenText;
                Symbol term = new Symbol(id, tokenStart, tokenEnd, (Object)text);
                terminals.add(term);
            }
            Collections.reverse(terminals);
            if (parser instanceof Parser) {
                Parser.Simulator sim = new Parser.Simulator((Parser)parser);
                for (Symbol terminal : terminals) {
                    in.insert(terminal);
                }
                if (sim.parse(in)) {
                    result = true;
                    in.rewind();
                    report.missingTokensInserted(terminals);
                }
            }
        }
        return result;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class CandidateToken {
        public final T tokenType;
        public final String tokenText;
        final /* synthetic */ InsertionRecoveryStrategy this$0;

        private CandidateToken(T tokenType, String tokenText) {
            this.this$0 = var1_1;
            this.tokenType = tokenType;
            this.tokenText = tokenText;
        }
    }
}

